% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast_ratio.R
\name{contrast_ratio}
\alias{contrast_ratio}
\title{W3C Contrast Ratio}
\usage{
contrast_ratio(
  col,
  col2 = "white",
  algorithm = c("WCAG", "APCA"),
  plot = FALSE,
  border = FALSE,
  cex = 2,
  off = 0.05,
  mar = rep(0.5, 4),
  digits = 2L,
  ...
)
}
\arguments{
\item{col, col2}{vectors of any of the three kind of R colors, i.e., either a color
name (an element of \code{\link[grDevices]{colors}}), a hexadecimal string
of the form \code{"#rrggbb"} or \code{"#rrggbbaa"} (see
\code{\link[grDevices]{rgb}}), or an integer \code{i} meaning
\code{palette()[i]}. Both can be vectors and are recycled as necessary.}

\item{algorithm}{character specifying whether the established standard \code{"WCAG"} 2.1 algorithm
should be used or the improved \code{"APCA"} 0.98G-4g algorithm, still under development.}

\item{plot}{logical indicating whether the contrast ratios should also be
visualized by simple color swatches. Can also be a vector of length 2, indicating
whether the foreground color should be visualized on the background color and/or
the background color on the foreground color.}

\item{border}{logical or color specification for the borders around the color swatches (only
used if \code{plot = TRUE}). The default is \code{FALSE} which is equivalent to
\code{"transparent"}. If \code{TRUE} the border is drawn in the same color as the text in the
rectangle.}

\item{cex}{numeric. Size of the text in the color color swatches (only if \code{plot = TRUE}).}

\item{off}{numeric. Vertical offset between the different color swatches (only if \code{plot = TRUE}).
Can also be of length 2 giving both vertical and horizontal offsets, respectively.}

\item{mar}{numeric. Size of the margins around the color swatches (only if \code{plot = TRUE}).}

\item{digits}{numeric. Number of digits for the contrast ratios displayed in the color swatches
(only if \code{plot = TRUE})}

\item{\dots}{further arguments passed to the plot of the color swatches (only if \code{plot = TRUE}).}
}
\value{
A numeric vector with the contrast ratios is returned (invisibly, if \code{plot} is \code{TRUE}).
}
\description{
Compute (and visualize) the contrast ratio of pairs of colors, as defined by the World Wide
Web Consortium (W3C).
}
\details{
The W3C Content Accessibility Guidelines (WCAG) recommend a contrast
ratio of at least 4.5 for the color of regular text on the background color, and
a ratio of at least 3 for large text. See \url{https://www.w3.org/TR/WCAG22/#contrast-minimum}.

The contrast ratio is defined in \url{https://www.w3.org/TR/WCAG22/#dfn-contrast-ratio}
as \code{(L1 + 0.05) / (L2 + 0.05)} where \code{L1} and \code{L2} are the relative luminances
(see \url{https://www.w3.org/TR/WCAG22/#dfn-relative-luminance}) of the lighter and darker
colors, respectively. The relative luminances are weighted sums of scaled sRGB coordinates:
\code{0.2126 * R + 0.7152 * G + 0.0722 * B} where each of \code{R}, \code{G}, and \code{B}
is defined as \code{ifelse(RGB <= 0.03928, RGB/12.92, ((RGB + 0.055)/1.055)^2.4)} based on
the \code{RGB} coordinates between 0 and 1.

For use in the next major revision of the WCAG a new advanced perceptual contrast algorithm
(APCA) has been proposed by Somers (2022), see also Muth (2022) for more background and details.
APCA is still under development, here version 0.98G-4g is implemented. Unlike the standard WCAG
algorithm, APCA takes into account which color is the text and which is the background. Hence
for the APCA algorithm a matrix with normal and reverse polarity is returned. An absolute
value of 45 is "sort of" like a WCAG ratio of 3, 60 is "sort of" like 4.5.
}
\examples{
# check contrast ratio of default palette on white background
contrast_ratio(palette(), "white")

# visualize contrast ratio of default palette on white and black background
contrast_ratio(palette(), "white", plot = TRUE)
contrast_ratio(palette()[-1], "black", plot = TRUE)

# APCA algorithm
contrast_ratio(palette(), "white", algorithm = "APCA")
contrast_ratio(palette(), "white", algorithm = "APCA", plot = TRUE, digits = 0)
}
\references{
W3C (2024). \dQuote{Web Content Accessibility Guidelines (WCAG) 2.2.}
\url{https://www.w3.org/TR/WCAG22/}

Somers A (2022). \dQuote{Advanced Perceptual Contrast Algorithm.}
\url{https://github.com/Myndex/SAPC-APCA}

Muth LC (2022). \dQuote{It's Time for a More Sophisticated Color Contrast Check for Data Visualizations.}
Datawrapper Blog. \url{https://www.datawrapper.de/blog/color-contrast-check-data-vis-wcag-apca/}
}
\seealso{
\code{\link[colorspace]{desaturate}}
}
\keyword{color}
