# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementJobStepsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_job_steps_list_by_version(self, resource_group):
        response = self.client.job_steps.list_by_version(
            resource_group_name=resource_group.name,
            server_name="str",
            job_agent_name="str",
            job_name="str",
            job_version=0,
            api_version="2020-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_job_steps_get_by_version(self, resource_group):
        response = await self.client.job_steps.get_by_version(
            resource_group_name=resource_group.name,
            server_name="str",
            job_agent_name="str",
            job_name="str",
            job_version=0,
            step_name="str",
            api_version="2020-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_job_steps_list_by_job(self, resource_group):
        response = self.client.job_steps.list_by_job(
            resource_group_name=resource_group.name,
            server_name="str",
            job_agent_name="str",
            job_name="str",
            api_version="2020-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_job_steps_get(self, resource_group):
        response = await self.client.job_steps.get(
            resource_group_name=resource_group.name,
            server_name="str",
            job_agent_name="str",
            job_name="str",
            step_name="str",
            api_version="2020-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_job_steps_create_or_update(self, resource_group):
        response = await self.client.job_steps.create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            job_agent_name="str",
            job_name="str",
            step_name="str",
            parameters={
                "action": {"value": "str", "source": "Inline", "type": "TSql"},
                "credential": "str",
                "executionOptions": {
                    "initialRetryIntervalSeconds": 1,
                    "maximumRetryIntervalSeconds": 120,
                    "retryAttempts": 10,
                    "retryIntervalBackoffMultiplier": 2,
                    "timeoutSeconds": 43200,
                },
                "id": "str",
                "name": "str",
                "output": {
                    "credential": "str",
                    "databaseName": "str",
                    "serverName": "str",
                    "tableName": "str",
                    "resourceGroupName": "str",
                    "schemaName": "dbo",
                    "subscriptionId": "str",
                    "type": "SqlDatabase",
                },
                "stepId": 0,
                "targetGroup": "str",
                "type": "str",
            },
            api_version="2020-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_job_steps_delete(self, resource_group):
        response = await self.client.job_steps.delete(
            resource_group_name=resource_group.name,
            server_name="str",
            job_agent_name="str",
            job_name="str",
            step_name="str",
            api_version="2020-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...
