/*---------------------------------------------------------*\
| RGBControllerKeyNames.cpp                                 |
|                                                           |
|   List of standardized names to represent keyboard keys   |
|   when naming LEDs on keyboard devices                    |
|                                                           |
|   Chris M (Dr_No)                             25 Jan 2022 |
|                                                           |
|   This file is part of the OpenRGB project                |
|   SPDX-License-Identifier: GPL-2.0-or-later               |
\*---------------------------------------------------------*/

#include "RGBControllerKeyNames.h"

const char* KEY_EN_UNUSED             = "";
const char* ZONE_EN_KEYBOARD          = "Keyboard";

const char* KEY_EN_ESCAPE             = "Key: Escape";
const char* KEY_EN_F1                 = "Key: F1";
const char* KEY_EN_F2                 = "Key: F2";
const char* KEY_EN_F3                 = "Key: F3";
const char* KEY_EN_F4                 = "Key: F4";
const char* KEY_EN_F5                 = "Key: F5";
const char* KEY_EN_F6                 = "Key: F6";
const char* KEY_EN_F7                 = "Key: F7";
const char* KEY_EN_F8                 = "Key: F8";
const char* KEY_EN_F9                 = "Key: F9";
const char* KEY_EN_F10                = "Key: F10";
const char* KEY_EN_F11                = "Key: F11";
const char* KEY_EN_F12                = "Key: F12";
const char* KEY_EN_PRINT_SCREEN       = "Key: Print Screen";
const char* KEY_EN_SCROLL_LOCK        = "Key: Scroll Lock";
const char* KEY_EN_PAUSE_BREAK        = "Key: Pause/Break";
const char* KEY_EN_POWER              = "Key: Power";

const char* KEY_EN_BACK_TICK          = "Key: `";
const char* KEY_EN_1                  = "Key: 1";
const char* KEY_EN_2                  = "Key: 2";
const char* KEY_EN_3                  = "Key: 3";
const char* KEY_EN_4                  = "Key: 4";
const char* KEY_EN_5                  = "Key: 5";
const char* KEY_EN_6                  = "Key: 6";
const char* KEY_EN_7                  = "Key: 7";
const char* KEY_EN_8                  = "Key: 8";
const char* KEY_EN_9                  = "Key: 9";
const char* KEY_EN_0                  = "Key: 0";
const char* KEY_EN_MINUS              = "Key: -";
const char* KEY_EN_PLUS               = "Key: +";
const char* KEY_EN_EQUALS             = "Key: =";
const char* KEY_EN_BACKSPACE          = "Key: Backspace";
const char* KEY_EN_INSERT             = "Key: Insert";
const char* KEY_EN_HOME               = "Key: Home";
const char* KEY_EN_PAGE_UP            = "Key: Page Up";

const char* KEY_EN_TAB                = "Key: Tab";
const char* KEY_EN_Q                  = "Key: Q";
const char* KEY_EN_W                  = "Key: W";
const char* KEY_EN_E                  = "Key: E";
const char* KEY_EN_R                  = "Key: R";
const char* KEY_EN_T                  = "Key: T";
const char* KEY_EN_Y                  = "Key: Y";
const char* KEY_EN_U                  = "Key: U";
const char* KEY_EN_I                  = "Key: I";
const char* KEY_EN_O                  = "Key: O";
const char* KEY_EN_P                  = "Key: P";
const char* KEY_EN_LEFT_BRACKET       = "Key: [";
const char* KEY_EN_RIGHT_BRACKET      = "Key: ]";
const char* KEY_EN_BACK_SLASH         = "Key: \\";
const char* KEY_EN_ANSI_BACK_SLASH    = "Key: \\ (ANSI)";
const char* KEY_EN_DELETE             = "Key: Delete";
const char* KEY_EN_END                = "Key: End";
const char* KEY_EN_PAGE_DOWN          = "Key: Page Down";

const char* KEY_EN_CAPS_LOCK          = "Key: Caps Lock";
const char* KEY_EN_A                  = "Key: A";
const char* KEY_EN_S                  = "Key: S";
const char* KEY_EN_D                  = "Key: D";
const char* KEY_EN_F                  = "Key: F";
const char* KEY_EN_G                  = "Key: G";
const char* KEY_EN_H                  = "Key: H";
const char* KEY_EN_J                  = "Key: J";
const char* KEY_EN_K                  = "Key: K";
const char* KEY_EN_L                  = "Key: L";
const char* KEY_EN_SEMICOLON          = "Key: ;";
const char* KEY_EN_QUOTE              = "Key: '";
const char* KEY_EN_POUND              = "Key: #";
const char* KEY_EN_ANSI_ENTER         = "Key: Enter";
const char* KEY_EN_ISO_ENTER          = "Key: Enter (ISO)";

const char* KEY_EN_LEFT_SHIFT         = "Key: Left Shift";
const char* KEY_EN_ISO_BACK_SLASH     = "Key: \\ (ISO)";
const char* KEY_EN_Z                  = "Key: Z";
const char* KEY_EN_X                  = "Key: X";
const char* KEY_EN_C                  = "Key: C";
const char* KEY_EN_V                  = "Key: V";
const char* KEY_EN_B                  = "Key: B";
const char* KEY_EN_N                  = "Key: N";
const char* KEY_EN_M                  = "Key: M";
const char* KEY_EN_COMMA              = "Key: ,";
const char* KEY_EN_PERIOD             = "Key: .";
const char* KEY_EN_FORWARD_SLASH      = "Key: /";
const char* KEY_EN_RIGHT_SHIFT        = "Key: Right Shift";
const char* KEY_EN_UP_ARROW           = "Key: Up Arrow";

const char* KEY_EN_LEFT_CONTROL       = "Key: Left Control";
const char* KEY_EN_LEFT_WINDOWS       = "Key: Left Windows";
const char* KEY_EN_LEFT_FUNCTION      = "Key: Left Fn";
const char* KEY_EN_LEFT_ALT           = "Key: Left Alt";
const char* KEY_EN_SPACE              = "Key: Space";
const char* KEY_EN_RIGHT_ALT          = "Key: Right Alt";
const char* KEY_EN_RIGHT_FUNCTION     = "Key: Right Fn";
const char* KEY_EN_RIGHT_WINDOWS      = "Key: Right Windows";
const char* KEY_EN_MENU               = "Key: Menu";
const char* KEY_EN_RIGHT_CONTROL      = "Key: Right Control";
const char* KEY_EN_LEFT_ARROW         = "Key: Left Arrow";
const char* KEY_EN_DOWN_ARROW         = "Key: Down Arrow";
const char* KEY_EN_RIGHT_ARROW        = "Key: Right Arrow";

const char* KEY_EN_NUMPAD_LOCK        = "Key: Num Lock";
const char* KEY_EN_NUMPAD_DIVIDE      = "Key: Number Pad /";
const char* KEY_EN_NUMPAD_TIMES       = "Key: Number Pad *";
const char* KEY_EN_NUMPAD_MINUS       = "Key: Number Pad -";
const char* KEY_EN_NUMPAD_PLUS        = "Key: Number Pad +";
const char* KEY_EN_NUMPAD_PERIOD      = "Key: Number Pad .";
const char* KEY_EN_NUMPAD_ENTER       = "Key: Number Pad Enter";
const char* KEY_EN_NUMPAD_0           = "Key: Number Pad 0";
const char* KEY_EN_NUMPAD_1           = "Key: Number Pad 1";
const char* KEY_EN_NUMPAD_2           = "Key: Number Pad 2";
const char* KEY_EN_NUMPAD_3           = "Key: Number Pad 3";
const char* KEY_EN_NUMPAD_4           = "Key: Number Pad 4";
const char* KEY_EN_NUMPAD_5           = "Key: Number Pad 5";
const char* KEY_EN_NUMPAD_6           = "Key: Number Pad 6";
const char* KEY_EN_NUMPAD_7           = "Key: Number Pad 7";
const char* KEY_EN_NUMPAD_8           = "Key: Number Pad 8";
const char* KEY_EN_NUMPAD_9           = "Key: Number Pad 9";

const char* KEY_EN_MEDIA_PLAY_PAUSE   = "Key: Media Play/Pause";
const char* KEY_EN_MEDIA_PREVIOUS     = "Key: Media Previous";
const char* KEY_EN_MEDIA_NEXT         = "Key: Media Next";
const char* KEY_EN_MEDIA_STOP         = "Key: Media Stop";
const char* KEY_EN_MEDIA_MUTE         = "Key: Media Mute";
const char* KEY_EN_MEDIA_VOLUME_DOWN  = "Key: Media Volume -";
const char* KEY_EN_MEDIA_VOLUME_UP    = "Key: Media Volume +";

const char* KEY_JP_RO                 = "Key: _";
const char* KEY_JP_EJ                 = "Key: E/J";
const char* KEY_JP_ZENKAKU            = "Key: 半角/全角";
const char* KEY_JP_KANA               = "Key: かな";
const char* KEY_JP_HENKAN             = "Key: 変換";
const char* KEY_JP_MUHENKAN           = "Key: 無変換";
const char* KEY_JP_YEN                = "Key: ¥";
const char* KEY_JP_AT                 = "Key: @";
const char* KEY_JP_CHEVRON            = "Key: ^";
const char* KEY_JP_COLON              = "Key: :";

const char* KEY_KR_HAN                = "Key: 한/영";
const char* KEY_KR_HANJA              = "Key: 한자";

const char* KEY_NORD_AAL              = "Key: Å";
const char* KEY_NORD_A_OE             = "Key: Ä Ø";
const char* KEY_NORD_O_AE             = "Key: Ö Æ";
const char* KEY_NORD_HALF             = "Key: § ½";
const char* KEY_NORD_HYPHEN           = "Key: - _";
const char* KEY_NORD_PLUS_QUESTION    = "Key: + ?";
const char* KEY_NORD_ACUTE_GRAVE      = "Key: ´ `";
const char* KEY_NORD_DOTS_CARET       = "Key: ¨ ^";
const char* KEY_NORD_QUOTE            = "Key: ' *";
const char* KEY_NORD_ANGLE_BRACKET    = "Key: < >";

const char* KEY_DE_ESZETT             = "Key: ß";
const char* KEY_DE_DIAERESIS_A        = "Key: Ä";
const char* KEY_DE_DIAERESIS_O        = "Key: Ö";
const char* KEY_DE_DIAERESIS_U        = "Key: Ü";

const char* KEY_FR_SUPER_2            = "Key: ²";
const char* KEY_FR_AMPERSAND          = "Key: &";
const char* KEY_FR_ACUTE_E            = "Key: é";
const char* KEY_FR_DOUBLEQUOTE        = "Key: \"";
const char* KEY_FR_LEFT_PARENTHESIS   = "Key: (";
const char* KEY_FR_GRAVE_E            = "Key: è";
const char* KEY_FR_UNDERSCORE         = "Key: _";
const char* KEY_FR_CEDILLA_C          = "Key: ç";
const char* KEY_FR_GRAVE_A            = "Key: à";
const char* KEY_FR_RIGHT_PARENTHESIS  = "Key: )";
const char* KEY_FR_DOLLAR             = "Key: $";
const char* KEY_FR_GRAVE_U            = "Key: ù";
const char* KEY_FR_ASTERIX            = "Key: *";
const char* KEY_FR_EXCLAIMATION       = "Key: !";

const char* KEY_ES_OPEN_QUESTION_MARK = "Key: ¿/¡";
const char* KEY_ES_TILDE              = "Key: ´/¨";
const char* KEY_ES_ENIE               = "Key: Ñ";
const char* KEY_BR_TILDE              = "Key: ~";
