// Generated by LiveScript 1.6.0
var ref$, id, isType, replicate, VERSION, eq, deepEq, ok;
ref$ = require('../..'), id = ref$.id, isType = ref$.isType, replicate = ref$.replicate, VERSION = ref$.VERSION;
ref$ = require('assert'), eq = ref$.strictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
suite('library', function(){
  return test('version', function(){
    return eq(VERSION, require('../../package.json').version);
  });
});
suite('id', function(){
  test('number', function(){
    return eq(5, id(5));
  });
  return test('object is the same', function(){
    var obj;
    obj = {};
    return eq(obj, id(obj));
  });
});
suite('is-type', function(){
  test('literals', function(){
    ok(isType('Undefined', void 8));
    ok(isType('Boolean', true));
    ok(isType('Number', 1));
    ok(isType('Number', 1.2));
    ok(isType('String', 'asdfa'));
    ok(isType('Object', {}));
    ok(isType('Array', []));
    return ok(!isType('Boolean', 1));
  });
  test('constructors', function(){
    return ok(isType('Date', new Date));
  });
  test('classes', function(){
    var A;
    A = (function(){
      A.displayName = 'A';
      var prototype = A.prototype, constructor = A;
      function A(){}
      return A;
    }());
    return ok(isType('Object', new A));
  });
  return test('curried', function(){
    var f;
    f = isType('Boolean');
    return ok(f(true));
  });
});
suite('replicate', function(){
  test('zero as input', function(){
    deepEq([], replicate(0, 0));
    return deepEq([], replicate(0, 'a'));
  });
  test('number as input', function(){
    return deepEq([3, 3, 3, 3], replicate(4, 3));
  });
  test('string as input', function(){
    return deepEq(['a', 'a', 'a', 'a'], replicate(4, 'a'));
  });
  return test('curried', function(){
    var f;
    f = replicate(4);
    return deepEq([3, 3, 3, 3], f(3));
  });
});
