/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.lucene.luke.app.desktop.util;

import java.lang.invoke.MethodHandles;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.luke.app.desktop.MessageBroker;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.util.LoggerFactory;

/** An utility class for handling exception */
public final class ExceptionHandler {

  private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

  public static void handle(Throwable t, MessageBroker messageBroker) {
    if (t instanceof LukeException) {
      Throwable cause = t.getCause();
      String message = (cause == null) ? t.getMessage() : t.getMessage() + " " + cause.getMessage();
      log.log(Level.WARNING, "Uncaught LukeException", t);
      messageBroker.showStatusMessage(message);
    } else {
      log.log(Level.SEVERE, "Uncaught Exception", t);
      messageBroker.showUnknownErrorMessage();
    }
  }
}
