// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package cmd

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/logger"

	"github.com/urfave/cli/v3"
)

var Version = "development"

func SetVerbosity(ctx context.Context, verbosity int) {
	l := logger.ContextGetLogger(ctx)
	switch verbosity {
	case 0:
		l.SetLevel(logger.Info)
	default:
		l.SetLevel(logger.Trace)
	}
}

func NewApp() *cli.Command {
	return &cli.Command{
		Name:        "F3",
		Usage:       "Friendly Forge Format",
		Description: `Friendly Forge Format`,
		Version:     Version,
		Before: func(ctx context.Context, c *cli.Command) (context.Context, error) {
			SetVerbosity(ctx, c.Count("verbose"))
			return nil, nil
		},
		Commands: []*cli.Command{
			CreateCmdMirror(),
		},
		Flags: []cli.Flag{
			&cli.BoolFlag{
				Name:  "verbose",
				Usage: "increase the verbosity level",
			},
			cli.VersionFlag,
		},
		EnableShellCompletion: true,
	}
}
