% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{st_split}
\alias{st_split}
\title{Return a collection of geometries resulting by splitting a geometry}
\usage{
st_split(x, y)
}
\arguments{
\item{x}{object with geometries to be splitted}

\item{y}{object split with (blade); if \code{y} contains more than one feature geometry, the geometries are \link{st_combine}d}
}
\value{
object of the same class as \code{x}
}
\description{
Return a collection of geometries resulting by splitting a geometry
}
\examples{
library(sf)
l = st_as_sfc('MULTILINESTRING((10 10, 190 190), (15 15, 30 30, 100 90))')
pt = st_sfc(st_point(c(30,30)))
lwgeom::st_split(l, pt)
}
