#!/bin/sh -e

VERSION=$2
TAR=../activemq_$VERSION.orig.tar.xz
DIR=activemq-$VERSION
TAG=$(echo "activemq-$VERSION" | sed -re's/~(alpha|beta)/-\1-/')

svn export https://svn.apache.org/repos/asf/activemq/tags/${TAG}/ $DIR
XZ_OPT=--best tar -c -J -f $TAR \
  --exclude '*.jar' \
  --exclude '*.class' \
  --exclude 'activemq-web-demo/src/main/webapp/js/dojo.js' \
  --exclude 'activemq-web-demo/src/main/webapp/js/jquery-1.4.2.min.js' \
  --exclude 'assembly/src/release/bin/linux-x86*' \
  --exclude 'assembly/src/release/bin/macosx' \
  --exclude 'assembly/src/release/bin/solaris' \
  --exclude 'assembly/src/release/bin/win*' \
$DIR
rm -rf $DIR ../$TAG

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
